# -*- coding: utf-8 -*-
"""
Created on Mon Apr 25 16:18:03 2022

@author: Adarsh Raghuram
This code can be used to quickly gain an idea as to what parameters 
to run a hollow stepper motor switch at.

"""

#Enter required switch time here in ms
t_time=30

#Enter moment of inertia of load here in gcc^2. 6gcc for WP in 3d printed mount
t_mom=6

#Enter operation mode here. 1 for full stepping, 2 for half stepping, 4 for quarter and so on
mode=4


#Enter target angle to be turned in degrees

t_angle=45

#enter step size of motor. 1.8 degrees for most motors. A few have different sizes

s_size=1.8

req_steps=t_angle*mode/s_size

import numpy as np
import matplotlib.pyplot as plt
import scipy
import math
import glob
import os
import pandas as pd
from scipy.optimize import curve_fit
def switch_time(acc,max_vel,dist):
    return 2*np.sqrt(dist/acc) - 2*np.sqrt(1/acc)


#Are you following the Five Steps for a succesful measurement?
f=True


t_acc=(((2*np.sqrt(req_steps) - 2*np.sqrt(1))*1000/t_time)**2)


#Moment of inertia of the shaft in gcm^2, found experimentally using a fit
shaft_mom=60

#prop. constant relating torque and current. Found experimentally for the motor
k_factor=0.0734

t_torque=(t_mom+shaft_mom)*t_acc*s_size/(mode*57.3*10000000)

t_current=t_torque/k_factor

print('The required number of steps is',req_steps)
if f==False:
    print('You might need',req_steps+5,'steps since you are not following the five steps' )

print('The required acceleration is',round(t_acc,-2),'spsps, with a switch time of', 
      round(1000*switch_time(round(t_acc,-2),0,req_steps),3),'ms')
if t_acc*t_time*15.5/(2*57*1000000)>330:
    print('The motor shaft is exceeding the speed of sound. Check the input parameters')
if t_acc*t_time*15.5/(2*57*1000000)>3*10**8:
    print('The motor shaft is exceeding the speed of light. Einstein is grumpy. Check the input parameters')
if t_acc<10000:
    print('Are you sure you want to go this slow?')
    
    
print('The required current (with a 10% extra leeway) is',round(1.1*t_current,2),'A')
if t_current*1.1 > 1 and t_current*1.1<1.2:
    print('Near the current limit for the motor')
if t_current*1.1 > 1.2 and t_current*1.1<1.8:
    print('At the current limit for the motor. The motor has been observed to behave badly here. Take care while using')
if t_current*1.1>1.8:
    print('Do not run at this current. Will fry motor')
if t_current*1.1>50:
    print('Check input parameters')
if t_current*1.1>5000:
    print('Are you trying to spin an elephant slowly or a waveplate really fast?')
v_max=round(t_acc*t_time/2000,-2)
print('The maximum velocity in this switch is',v_max,'spsps')
if v_max>40000:
    print('Over max step velocity')
